-> Start

// Dashiell Hamlett: The Blue Dane Meets the Black Bird
// by Tony Pisculli
//
// Based on the one-act play

VAR mail = 0
VAR window = 0

VAR news = false

VAR raven = false
VAR client = false

VAR rapier = false
VAR revolver = false
VAR card = false

VAR swear = false

VAR Rosencrantz_alive = true
VAR Guildenstern_alive = true

=== Start ===
You find yourself in a room with one door, currently closed, and a window, currently open.

The cheap wooden desk is littered with a pile of old mail. In one corner, a bottle of scotch stands sentry beside an unwashed shot glass.

A sixteenth-century rapier lies across the desk on a diagonal. Crossing it, a .45 caliber Colt revolver. Framed between the two weapons is a business card.

Against the wall across from the open window stands an old grandfather clock, ticking away the seconds of your life.

The air is heavy with the smell of death. Trouble is brewing, like a bad cup of coffee.

You&rsquo;re all too familiar with this place. This is ...
-> Office

==== Office ===
// Can't CLEAR here - CLEAR before returning to office instead
Your office.
* {client} [Follow the man in armor]
    You can&rsquo;t open the door. You appear to be locked in your own office.
    You decide to spend the night here.
    It&rsquo;s just that, sometimes, when you sleep alone, you have bad dreams.
* [Examine business card]
    # CLEAR
    ~ card = true
    The card, which appears to be hand typed, reads, &ldquo;Dashiell Hamlett.&rdquo;
    And below that, &ldquo;Private Investigator.&rdquo;
    And below <em>that</em>, &ldquo;Prince of Denmark.&rdquo;
    The card is yours. You are Dashiell Hamlett&mdash;a regular joe who happens to be heir to the throne and a straight-shooting, wise-cracking private detective. You have unprotected sex with beautiful women who carry handguns. You smoke unfiltered cigarettes and drink straight scotch. You take your eggs hard-boiled. You drink your coffee <em>noir</em>.
    ++ [Smoke an unfiltered cigarette and drink straight scotch]
        At the same time? You do live dangerously. The fireball nearly takes your eyebrows off.
    You run this detective agency&mdash;<em>Hamlett and Son</em>&mdash;with your father, the King. He&rsquo;s <em>Hamlett</em>. You&rsquo;re <em>Son</em>. It&rsquo;s been awhile since you&rsquo;ve seen him, though. 
    You tuck the card away for later.
* [Take rapier]
    {
        - revolver:
            One weapon is probably enough. For now.
        - else:
            The rapier suits you perfectly, like shaking hands with an old friend. You slip it into the hanger on your belt.
            ~ rapier = true
    }
* [Take revolver]
    {
        - rapier:
            One weapon is probably enough. For now.
        - else:
            The revolver smells of gunpowder and bad choices, but you&rsquo;ve got a home for it on your hip.
            ~ revolver = true
    }
+ { card and (mail < 3) } [Read mail]
    {
        - client:
            -> Mail (-> Office)
        - raven:
            -> Client (-> Office)
        - else:
            -> Raven (-> Office)
    }
* {card} [Open door]
    Your office door is locked. From the outside. Strange.
* {card} [Close window]
    The window seems to be stuck open.
    ~ window += 1
    { not raven: 
        -> Raven (-> Office)
    }
    // if raven has already entered, don&rsquo;t let it come in again
    // -> Raven (-> Office)
* {Ghost} [Drink scotch]
    Mmm. So much better when it's not on fire.
    -> Office
* {Claudius} [Examine grandfather clock]
    -> Clock (-> Office)
* {window} {not Mouse} [Look out window]
    The city is quiet. Too quiet. The city is like a living thing. Even when it sleeps, it has its own sound, its own rhythm. But now? Not a creature is stirring.
    -> Mouse (-> Office)
* {window} {Mouse} {client} {news} [Look out window]
    -> Ghost (-> Office)
+ [Wait]
    {
        //- Client and not Telephone:
        //    -> Telephone (-> Office)
        - Ghost and not Ophelia:
            -> Ophelia (-> Office)
        - Ophelia and not Telephone:
            -> Telephone (-> Office)
        - Telephone and not Polonius:
            -> Polonius (-> Office)
        - Polonius and news and not Gertrude: 
            -> Gertrude
        - Gertrude and not Claudius:
            -> Claudius
        - Exterminator:
            -> Finale
        - else:
            Maybe you&rsquo;ll get lucky. Ninety percent of a private eye&rsquo;s job is waiting to get lucky.
            Time passes.
            -> Office
    }
- -> Office

=== Clock (-> back) ===
    You notice for the first time that the clock is running backwards. Odd. Now that you think of it, the clock struck <em>one</em> when the mouse ran down. Later it chimed midnight, just before your father&rsquo;s ghost appeared. Could it have any deeper significance? Or is it just broken?
    -> back

=== Mouse (-> back) ===
# CLEAR
~ temp stab = false
~ temp shoot = false
A mouse bolts from a hole in the baseboard and runs up the grandfather clock.
* [Call exterminator]
* {revolver} [Shoot mouse]
    ~ shoot = true
    You {revolver:draw your Colt|snatch the revolver off your desk} and fire several shots at the mouse.
* {rapier} [Stab mouse]
    ~ stab = true
    You {rapier:draw your sword|snatch the rapier off your desk} and thrust wildly at the mouse.
-  The clock strikes one with a loud <em>bong</em>. The mouse scampers down in a broken-field running pattern{shoot:, dodging your bullets,|{stab:, dodging your thrusts,}} and disappears into his hidey-hole. You jot down a reminder to yourself to call The Exterminator.
- -> back

=== Telephone (-> back) ===
# CLEAR
Somewhere, a phone rings. Could it be Destiny on the line?
The phone rings again, yet you don&rsquo;t answer. Why? Could you be afraid to face your own destiny?
The phone rings a third time.
A man is defined by his actions, yet you don&rsquo;t act. Failure to act could itself be taken as an action.
The ringing stops.
Who was it? You&rsquo;ll never know. They say Opportunity knocks but once, but no one keeps track of how many times it calls.
-> back

=== Raven (-> back) ===
# CLEAR
~ raven = true
A large black bird darts in through the open window{window:, beating its wings in your face before finding its way into the room}. It circles your office once, then takes up residence on the grandfather clock.
&ldquo;Nevermore.&rdquo; # CLASS: raven
It can speak. Ominous. A superstitious man might be unnerved.
+ But you aren&rsquo;t a superstitious man.
+ And you are. Very superstitious. And extremely unnerved.
    You try shooing the raven away. It glares at you balefully and refuses to move.
- -> back

=== Client (-> back) ===
# CLEAR
~ client = true
Suddenly there comes a tapping, as of someone gently rapping, rapping on your office door.
&ldquo;Elsinore!&rdquo; # CLASS: raven
The door swings open with a <em>creeeeak</em>, and <em>he</em> walks in, clad in full-plate armor, looking like trouble and smelling like yesterday&rsquo;s meatloaf.
And yet he seems familiar. He wears his beaver down, so you can&rsquo;t make out his face, but something about him ... haunts you.
+ [Lift his beaver]
    You reach to lift his beaver, to get a glimpse of who exactly you&rsquo;re dealing with. He grabs your wrist in a crushing grip, the steel edges of his armored gauntlets digging into your flesh.
    &ldquo;Don&rsquo;t. Touch. The beaver.&rdquo; # CLASS: ghost
+ [Wait for him to speak]
    He&rsquo;s a taciturn fellow. He says nothing.
    You don&rsquo;t like talking to a man who doesn&rsquo;t like to talk. You distrust a quiet man. He usually knows more than you and refuses to tell you what he knows.
- Eventually he feeds you a story. Someone&rsquo;s been tailing him, and he needs protection. He wants to hire you to follow him at midnight, and see if you can pick up the tail.
+ &ldquo;Ninety percent of a private eye&rsquo;s job is chasing tail.&rdquo;
-
# CLEAR
He drops a bag of coins on your desk with a jingle, and just like that, he&rsquo;s gone, before the crow of the cock&mdash;<strong>&ldquo;Out the door!&rdquo;</strong>&mdash;leaving behind him a foul odor in the shape of a man and a stack of unanswered questions in the shape of ... a stack.
Who was that masked man? Why was he wearing armor? Why does he need protection when he can clearly take care of himself? And why does he smell so bad?
You don&rsquo;t believe his story for a hearbeat&mdash;but you believe his 20 pieces of gold. He paid you more than if he&rsquo;d been telling the truth and enough more to make it alright.
You have a client.
-> back

=== Mail (-> back) ===
# CLEAR
{
    - mail == 0:
    Bills, bills, bills ... Hmm. Some of these look personal.
}
* [Examine light envelope]
    What&rsquo;s this? Something rotten from Hallmark?
    A wedding invitation. Looks like some unforunate dame has fallen for that slick line of patter your uncle peddles.
    ~ mail += 1
    ++ [Open invitation]
        Frailty, thy name is mother!
        Your mind reels.
        Your uncle is marrying your mother. She&rsquo;s certainly always been a woman of enormous sexual appetitite. Still, your father will have something to say about this. {news:Or he would have, if he were still alive. Damn.}
* [Examine dark envelope]
    A funeral notice. Your father is dead. Dead for a ducat. Dead as a duck. A dead duck.
    Well, you won&rsquo;t lose any sleep over it. You never liked the old bastard.
    You make a note for your secretary to have &ldquo;Hamlett and Son&rdquo; taken off the door and just &ldquo;Son&rdquo; put on.
    ~ mail += 1
    ~ news = true
* [Examine bright envelope]
    &ldquo;Dear Hamlett, we&rsquo;re writing to you today about your car&rsquo;s extended warranty ...&rdquo;
    ~ mail += 1

- -> back

=== Ghost (-> back)
# CLEAR
You take up your lonely post at the open window&mdash;waiting for something to happen, waiting for someone to open the door, waiting for another client, waiting till midnight so you can follow the client you already have for the job you were hired to do.
The clock strikes twelve. Midnight. The witching hour. Now the line between good and evil is as thin as the line between one day and the next. Invisible. Intagible. When you walk this close to the line, sometimes you lose your footing. Sometimes you find yourself on the other side without even realizing it.
+ [Look down]
-
# CLEAR
You gaze out the window at the street two stories below.
There&rsquo;s your client! He&rsquo;s pretty nimble, for a man in armor. You&rsquo;d almost swear his feet aren&rsquo;t touching the ground.
He glances over his shoulder, checking to be sure he&rsquo;s not being followed. Or to be sure that he is? His eyes glow like coals behind his visor, and you begin to entertain certain suspicions.
Client or creature from hell? Spirit of grace or goblin damned?
Hard to say from here. You get all types in this business. If only he&rsquo;d lift his damned beaver.
Suddenly he looks up and sees you framed in the open window.
+ [Close window]
    You attempt to close the window, but it&rsquo;s still stuck.
- Your client crosses the street and stands directly below you. You begin to speculate on what his black purpose might be as, slowly, he begins to rise, floating up to your level.
+ [Confront him]
    &ldquo;All right, let&rsquo;s have the truth. All of it. Be thy intents wicked or charitable? Bring with thee airs from heaven or blasts from hell?&rdquo;
- He says nothing.
+ [Accuse him]
- &ldquo;That story you told me back in the office was just that, wasn&rsquo;t it? A story? No one&rsquo;s following you but me. And you&rsquo;re not in fear for your life because&mdash;&rdquo;
+ [Take a dramatic pause]
- &ldquo;&mdash;you&rsquo;re already dead!&rdquo;
&ldquo;Hamlett, I am your father.&rdquo; # CLASS: ghost
+ [Accept it]
    Suddenly it all makes too much sense. Your client is dead. Your father is dead. Ergo, by hypothetical syllogism, your client is your father.
+ [Deny it]
    &ldquo;Noooooo! You&rsquo;re not my father! You can&rsquo;t be my father!&rdquo;
- He lifts his beaver, removing all doubt. It&rsquo;s your father&rsquo;s face behind the mask&mdash;worm-eaten <em>and</em> slightly translucent, making him some sort of zombie ghost?
+ [Ask what he wants]
- (avenge_me)
&ldquo;Avenge me.&rdquo; # CLASS: ghost
    * [Agree]
        &ldquo;Rest, rest, perturbed spirit. Hamlett, P.I. is on the job.&rdquo;
        Now all you have to do is solve your father&rsquo;s murder ...
        But wait&mdash;you&rsquo;ve got the victim right here. Sure, you&rsquo;ll beat the truth out of an innocent bystander when you have to, but if there&rsquo;s an easier way, you&rsquo;ll take it.
        ++ &ldquo;Who killed you?&rdquo;
                &ldquo;The Fat Man.&rdquo; # CLASS: ghost
                -> agreed_to_avenge
    * [Refuse]
        &ldquo;I&rsquo;m a detective, not an assassin.&rdquo;
        -> avenge_me
- (agreed_to_avenge)

The King&rsquo;s ghost exits, not bothering to open the door before sailing through it.
You&rsquo;re alone.
On the one hand, it&rsquo;s the longest conversation you&rsquo;ve ever had with your father. On the other hand, murder for hire isn&rsquo;t exactly your style.
Oh cursed spite, that ever you were born to put it right.
Still, when someone bumps off your old man, you&rsquo;re supposed to do something about it, whether you liked him or not.
+ [Follow ghost]
-
# CLEAR
You try to open the door, but no. Still locked. Which raises the additional question of how you&rsquo;re going to carry out this vengeance when you can&rsquo;t even escape your office.
Can you even do it? Murder a man just because he&rsquo;s murdered another man, nevermind that that man was your father. They say that two wrongs don&rsquo;t make a right, but three rights make a left. It gets harder every day to distinguish left from right and right from wrong. Sometimes you feel like the whole world is turning <em>en dedans</em> and you&rsquo;re turning&mdash;<strong>&ldquo;En dehors!&rdquo;</strong>&mdash;the other way.
The best you can do is try to maintain some kind of grace under pressure.
Black, white, up, down, male, female, all rolled together like two lumps of clay into an indistinguishable gray. There are no moral absolutes. The compass points in all directions. And when the end comes, it won&rsquo;t matter who was good, who was bad. The only question is, who&rsquo;s going to take the fall.
You get so tired of it all, so tired, you just want to sleep ... the Big Sleep.
&ldquo;Nevermore.&rdquo; # CLASS: raven
To sleep, perchance to dream. Ay, there&rsquo;s the rub. You could count yourself king of infinite space, were you not bounded in your office with your bad dreams.
Every night, you lay awake, counting infinite sheep, sure that the morning will never come.
But, somehow, it always does.
+ [Wait]
- # CLEAR
-> back

=== Polonius (-> back)
# CLEAR
The door swings open, and a slight, weasel-faced man wafts in on a cloud of scent. He looks like trouble, but he smells like ... gardenia?
By way of introduction, he proffers his card.
+ [Read card]
    The card is elegantly typeset. It reads, &ldquo;Polonius J. Cairo.&rdquo;
    And below that, &ldquo;General and Financial Services.&rdquo;
    And below <em>that</em>, &ldquo;Advice given. Familiarities taken.&rdquo;
- The card, too, smells of gardenia. There&rsquo;s more written on the other side.
+ [Read other side]
    In smaller type, the other side of the card reads,
    &ldquo;Sailing lessons. Giving Blessings. Tongue lashings. Bullion stashing. Adoptions. Stock options. Fledglings hatched. Checks cashed. Quarrels started. Fools and their money parted.&rdquo;
    And below that, in even smaller type,
    &ldquo;Animal husbandry. Husband cuckoldry. Cuckoo clockery. Borrowing. Lending. Etc.&rdquo;
- Cairo. The name sounds familiar.
+ &ldquo;You wouldn&rsquo;t be related to Ophelia, would you?&rdquo;
- He waves off the question, and says he represents a certain party that&rsquo;s prepared to pay handsomely for &ldquo;the dingus.&rdquo;
+ [Ask how much]
    &ldquo;My client is prepared to pay five thousand dollars.&rdquo; # CLASS: polonius
    ++ [Agree]
        &ldquo;Five thousand dollars, then. You&rsquo;ll let my client know if it turns up?&rdquo; # CLASS: polonius
    ++ [Refuse]
        &ldquo;I wouldn&rsquo;t touch your dingus for ten thousand.&rdquo;
        &ldquo;Ten thousand dollars, then.&rdquo; # CLASS: polonius
        You hesitate, and he asks if you&rsquo;re a bird fancier.
        +++ &ldquo;I&rsquo;m as straight as the day is long.&rdquo;
        ---&ldquo;In Denmark? In winter?&rdquo; # CLASS: polonius
            He frowns.
            &ldquo;But if you&rsquo;re not straight with me, you&rsquo;ll have to deal with my client.&rdquo; # CLASS: polonius
    --
    ++ &ldquo;Who&rsquo;s your client?&rdquo;
    -- &ldquo;The Fat Man.&rdquo; # CLASS: polonius
    ++ [Give Polonius your card]
        You turn to your desk to grab one of your business cards and hear a rustle behind you. You spin around to discover Polonius gone, the curtain swaying slightly in the wake of his rapid exit. {card:In retrospect, you could have just handed him the card you&rsquo;ve got in your pocket.}
    ++ {not revolver} [Shoot Polonius]
        You turn to grab your revolver from your desk and hear a rustle behind you. You spin around to discover Polonius gone, the curtain swaying slightly in the wake of his rapid exit. {rapier:In retrospect, you could have just run him through with the rapier in your belt.}
    ++ {not rapier} [Stab Polonius]
        You turn to grab your rapier from your desk and hear a rustle behind you. You spin around to discover Polonius gone, the curtain swaying slightly in the wake of his rapid exit. {revolver:In retrospect, you could have just shot him with the revolver on your hip.}
    -- You never should have turned your back on the man.
- He&rsquo;s given you a lot to think about. He&rsquo;d lost his dingus. Or someone else&rsquo;s dingus. But there&rsquo;s more than one dingus in the sea. Probably. More dinguses under heaven and earth than ... one dingus.
Still, he was prepared to pay handsomely for this particular dingus. You should be on your guard, in case he tries to steal it. Or maybe he already has?
+ [Search office]
- A quick search of your office turns up exactly zero dinguses. But since you don&rsquo;t know what it is or what it looks like that&rsquo;s hardly surprising.
-> back

=== Gertrude ===
# CLEAR
Then <em>she</em> walks in. She looks like heaven and smells like sin.
She grabs you and runs her fingers through your hair, and all over your body.
&ldquo;I&rsquo;ve got to have it.&rdquo; # CLASS: gertrude
+ &ldquo;Hands off, Mrs. Oedpius!&rdquo;
- She has golden hair, blood red lips and violent eyes to die for. She&rsquo;s a knockout. Too bad she&rsquo;s your mother. Well, you know what they say&mdash;blood is thicker than water and more likely to stain.
&ldquo;I want what your father left you.&rdquo; # CLASS: gertrude

+ &ldquo;A crippling lack of self-esteem?&rdquo;
+ &ldquo;The detective agency?&rdquo;
+ &ldquo;The dingus?&rdquo;
- Before she can respond, something rustles behind the drapes. You smell a rat!
&ldquo;Pay no attention to the man behind the curtain!&rdquo; # CLASS: gertrude

~ temp shoot = false
~ temp stab = false
+ {rapier} [Stab rat]
    ~stab = true
    You draw and thrust in one smooth motion, your rapier almost springing from its hanger. The point lands with a <em>thwik</em> in something meaty.
+ {revolver} [Shoot rat]
    ~ shoot = true
    You fire from your hip. <em>Bam! Bam! Bam!</em> Three perfect holes appear in the drapes, and blood begins to pool on the floorboards.
+ {not rapier and not revolver} [Throttle rat]
    If only you&rsquo;d had the foresight to acquire a weapon! You&rsquo;re forced to kill the rat with your bare hands, grabbing it blindly through the curtain and squeezing the life out of it.
- A body slumps to the floor.
+ [Open curtain]
- You open the curtain and find not a mouse but a man.
Polonius.
Subconsciously you must have known it. Why else would you have {shoot:fired|{stab:thrust|choked}} at {shoot or stab:chest|neck} height?
+ [Close curtain]
-
&ldquo;He&rsquo;s not going to like this.&rdquo; # CLASS: gertrude
+ &ldquo;Who? Your husband?&rdquo;
- &ldquo;The Fat Man.&rdquo; # CLASS: gertrude
<em>Boom</em>.
Ripples form on the surface of the whiskey in the bottle on your desk.
<em>Boom.</em>
The walls of your office shake.
<em>Boom.</em>

Your office.
+ [Wait]
-
-> Claudius

=== Claudius ===
# CLEAR
Suddenly there comes a bumping, as of someone madly thumping, thumping on your office door.
Then <em>he</em> walks in. He looks like trouble. He smells like trouble. If you stepped on him, you&rsquo;d have trouble scraping him off your shoe. She called him The Fat Man, but his name is Claudius. Claudius the King. Claudius the Usurper.
Claudius your step-father.
+ [Greet him calmly, despite the fact that he killed your father to marry your mother]
    &lquo;Uncle.&rquo;
+ [Greet him with the appropriate profanity]
    ~ swear = true
    &ldquo;Motherfucker!&rdquo;
    &ldquo;She&rsquo;s a whore!&rdquo; # CLASS: raven
    Gertrude slaps you. You slap the raven, aware you&rsquo;re only perpetuating the cycle of violence.
    You retarget your ire on your step-father, where it belongs.
-
&ldquo;So, have you got Rosencrantz and Guildenstern in your pockets, or are you just happy to see me?&rdquo;
He does. He&rsquo;s brought them along to glean what afflicts you.
At the sound of their names, Rosencrantz and Guildenstern scramble out of the Usurper&rsquo;s pockets with an audible <em>pop</em> and run around the room.
 And, sure, there aren&rsquo;t two men living to whom you more adhere, but that was in your youth. You&rsquo;ve outgrown them.
+ { revolver } [Shoot Rosencrantz]
    ~ Rosencrantz_alive = false
    The .45 caliber bullet catches the pocket-sized Rosencrantz high in the chest, separating his head and shoulders from the rest of him. He&rsquo;s literally half the man he used to be, and he wasn&rsquo;t big to begin with.
    Guildenstern wails and hides.
+ { rapier } [Stab Guildenstern]
    ~ Guildenstern_alive = false
    You skewer Guildenstern like a kebab. Rosencrantz shrieks and hides.
+ [Step on both of them]
    You stamp the floor, but they&rsquo;re too quick for you. They disappear into some hidey-hole.
- &ldquo;They are the King&rsquo;s spies, and I&rsquo;ll none of them.&rdquo;

Claudius grabs you by the throat and lifts you off the floor with one muscular arm. Your feet dangle as he demands you turn over the Falcon.
- (falcon_loop)
* [Refuse]
    You whisper &ldquo;no&rdquo; through strangled vocal cords. Claudius tightens his grip on your neck.
    -> falcon_loop
* &ldquo;What falcon?&rdquo;
* &ldquo;Heck, you know what? Take any falcon you see.&rdquo;
    &ldquo;It&rsquo;s not just <em> any falcon.&rdquo; # CLASS: claudius
- He describes a solid gold falcon, studded with gems&mdash;The Maltese Falcon&mdash;that&rsquo;s since been coated in black enamel to disguise its worth.
He proceeds to bore you with his adventures in tracking the Falcon across two continents. Paris. Moscow. Istanbul. Hong Kong. Denmark.
&ldquo;Elsinore!&rdquo; # CLASS: raven
It&rsquo;s endless. He has slides.
He&rsquo;s spent eighteen years tracking the Falcon, only to discover that all along, your father had it.
+ &ldquo;And you killed him for it.&rdquo;
- Funny. You never liked your father much when he was alive. But to learn he&rsquo;d been killed over a knick-knack? A little vengeance might be in order.
+[Kill Claudius]
    {
        - revolver or rapier:
            You reach for the weapon on your hip, but before you can lay your hand on it, <>
        - else:
            You reach for the Usurper&rsquo;s throat, but before you can lay a finger on him, <>
    }
- Claudius punches you.
<em>Again.</em>
<em>And again.</em>
Everything was so much simpler when you were younger. You saw the world in shades of black and white.
<em>And again.</em>
But now you see the world in black and blue.
<em>And again.</em>
Mostly blue.
As you&rsquo;re sinking into an inky pool of sleep, you hear the Fat Man&rsquo;s voice.
&ldquo;Call the Exterminator for Hamlett.&rdquo; # CLASS: claudius
Your mother bends to give you a kiss on the cheek.
&ldquo;Good night, sweet-pea.&rdquo; # CLASS: gertrude
+ [Sleep]
- -> Exterminator

=== Exterminator ===
# CLEAR
You slowly regain consciousness. Your head hurts. You have six missed calls from Ophelia.
Everyone, it turns out, has been looking for the same thing, your father&rsquo;s black bird.
But if he was so rich, why was he working as a gumshoe in this two-bit office?
Something doesn&rsquo;t add up.
Besides, the only black bird you&rsquo;ve ever seen your father with is the ratty old crow he used to feed sometimes in the back yard under the tree.
&ldquo;Sycamore!&rdquo; # CLASS: raven
+ &ldquo;You!&rdquo;
-
# CLEAR

The raven flaps his wings then settles back onto the pediment of the clock.
There&rsquo;s a knock on the door and a voice calls out.
&ldquo;Hello? Anyone there?&rdquo; # CLASS: exterminator
Before you can respond, the door swings open&mdash;the door it seems that everyone but you can open.
A man walks in wearing a helmet and a canvas suit with vulcanized rubber seals at the neck and cuffs. He looks like a deep sea diver.
+ &ldquo;Who are you?&rdquo;
-
# CLEAR

The man turns slightly and points to his back where &ldquo;EXTERMINATOR&rdquo; is written in block letters.
&ldquo;Oh, and don&rsquo;t mind the mask. I just wear it because I have a mild allergic reaction to some of the toxins. I&rsquo;m going to get started, okay?&rdquo; # CLASS: exterminator
He notices the open window and pulls it shut without trouble.
He sets a large tank on the floor and opens the valve. Clouds of white smoke billow forth, filling the room.

~ temp poisoned = false
~ temp hypoxic = false
+ [Breathe]
    ~ poisoned = true
    You inhale. Ugh. It&rsquo;s bad. Even for a man who smokes unfiltered cigarettes.
+ Hold your breath
    ~ hypoxic = true
    Smart.
- 
&ldquo;You&rsquo;ll notice your smaller pests will die straight off. Slightly bigger vermin will have a reaction.&rdquo; # CLASS: exterminator
From its baseboard hole, the mouse crawls out, wheezing, before it spasms and dies.

+ [Breathe]
    ~ poisoned = true
    You suck in a deep lungful of poison. It&rsquo;s like you have a deathwish or something.
+ {not hypoxic} [Hold your breath]
    ~ hypoxic = true
    Wise.
+ {hypoxic} [Keep holding your breath]
    Good choice, but you&rsquo;re starting to feel hypoxic.
-
&ldquo;Don&rsquo;t worry, though, they don&rsquo;t actually feel anything. It&rsquo;s just reflexes.&rdquo; # CLASS: exterminator

+ [Wait]
-
# CLEAR

Polonius crawls out from beneath the curtain, still bleeding, now coughing horribly.
&ldquo;Help me. Please, help. I have a child.&rdquo; # CLASS: polonius

{
    - Rosencrantz_alive and Guildenstern_alive:
        Rosencrantz and Guildenstern stagger out of their hiding place, choking on the gas, and manage to climb into the pockets of Polonius just before they die. 
    - Rosencrantz_alive:
        Rosencrantz staggers out of his hiding place, choking on the gas, and lays down by the tiny, skewered body of his friend before he dies.
    - Guildenstern_alive:
        Guildenstern staggers out of his hiding place and lays down by the remains of his friend before he dies.
}

~ temp tried_to_open_door = false
- (kill_exterminator_loop)
* [Open door]
    The door is locked. You&rsquo;re going to die in here.
    ~ tried_to_open_door = true
    -> kill_exterminator_loop
* [Open window]
    The window is still stuck; it&rsquo;s just stuck in the closed position now.
    -> kill_exterminator_loop
* {tried_to_open_door} [Kill Exterminator]
    {
    - poisoned and hypoxic:
        Weak from the toxins and lack of oxygen, you&rsquo;re forced to act.
    - poisoned:
        Weak from the toxins, you&rsquo;re forced to act.
    - hypoxic:
        Weak from lack of oxygen, you&rsquo;re forced to act.
    }
    You yank the Exterminator&rsquo;s mask off and put it on yourself.
- &ldquo;Hey, stop! What are you doing?&rdquo; # CLASS: exterminator
He claws at you, trying to recover the mask, but he&rsquo;s already succumbing to the gas.
&ldquo;Hit the floor!&rdquo; # CLASS: raven
The Exterminator writhes horribly, arching his back and gasping like a fish out of water before mercifully laying still.
You curl up on your desk, alone but surrounded by death.
-> Office

=== Arm (-> back) ===
You&rsquo;re going to need a weapon.
+ [Take revolver from desk]
    The revolver smells of gunpowder and bad choices, but you&rsquo;ve got a home for it on your hip.
    ~ revolver = true
+ [Take rapier from desk]
    The rapier suits you perfectly, like shaking hands with an old friend. You slip it into the hanger on your belt.
    ~ rapier = true
- -> back

// fight

=== function Hit(hits) ===
{
    - hits == 0:
        &ldquo;A hit! A very palpable hit!&rdquo;
        Laertes angrily wipes the blood away.
    - hits == 1:
        &ldquo;Another touch! What say you?&rdquo;
        &ldquo;A touch, a touch, I do confess it.&rdquo; # CLASS: ophelia
}

=== Finale ===
# CLEAR
You hear footsteps pounding up the hall toward your office. You recognize those footsteps. They&rsquo;re the footsteps that killed your father, the rightful king. The footsteps you&rsquo;re destined to take revenge on. The footsteps of Claudius. The Fat Man. The Usurper.
+ [Kill Claudius]
    {
        - rapier or revolver:
            That seems the obvious choice. Instead, you hide. To create a &ldquo;strategic advantage.&rdquo;
        - else:
            -> Arm (->Finale.armed)

    }
+ [Hide]
    You hide to create a strategic advantage.
- (armed)

Claudius enters and views the carnage. You see it fresh through his eyes. Polonius, eyes and mouth crusted with dried blood. Rosencrantz and Guildenstern, contorted with pain. The Exterminator, lying prone in a pool of his own vomit. The mouse.
+ [Kill Claudius]
- You emerge from your hiding place and stand behind him. &ldquo;And so am I revenged!&rdquo; You draw your {rapier:rapier|Colt} ... and hesitate.
Claudius kneels and crosses himself in the face of so much death.
+ [Kill Claudius]
- &ldquo;Now he is praying. And now I&rsquo;ll do it.&rdquo;
And yet ... you don&rsquo;t.
Claudius rolls over the body of the Exterminator, almost reverentially, to see his face. He&rsquo;s shocked that it&rsquo;s not you.
+ [Kill Claudius]
- &ldquo;A villain kills my father; and for that I, his sole son, do this same villain send to heaven.&rdquo;
But you can&rsquo;t seem to follow through. Why?
Claudius stands and exits. You have no doubt that he&rsquo;ll be back.
+ [Rationalize]
- &ldquo;When he is drunk asleep, or in his rage, or in the incestuous pleasure of his bed, at gaming, swearing, or about some act that has no relish of salvation in’t, <em>then</em> trip him that his heels may kick at heaven, and that his soul may be damned and black as hell, whereto it goes.&rdquo;
But are you really holding out for damnation? Or just chicken-shit?
+ [Holding out for damnation]
    Yeah. You&rsquo;re holding out for damnation. That sounds ... plausible.
+ [Chicken-shit]
    You slap yourself in the face. For courage.
-
+ [Wait]
-
# CLEAR

Then they burst in. And if trouble were a three-piece living room set, it would fill the room and clash with everything.
- (greet_loop)
* [Greet Claudius]
    {
        - swear:
            &ldquo;Motherfucker.&rdquo;
        - else:
            &ldquo;Uncle.&rdquo;
    }
    -> greet_loop
* [Greet Gertrude]
    &ldquo;Mother.&rdquo;
    -> greet_loop
* [Greet Laertes]
    &ldquo;Laertes? What are you doing here? It&rsquo;s awfully late in the game for a new character.&rdquo;
- Laertes draws his rapier.
+ [Apologize]
    ++ [For Ophelia]
        &ldquo;I&rsquo;m sorry about Ophelia. She deserved better.&rdquo;
        &ldquo;You also killed my father. <>
    ++ [For Polonius]
        &ldquo;I&rsquo;m sorry I killed your father. He&rsquo;s much taller than a rat.&rdquo;
        &ldquo;Not the apology I was looking for. <>
    --
-
Now I&rsquo;m going to kill you.&rdquo; # CLASS: ophelia

~ temp hits = 0
- (fight_loop)
*[Cut]
    You flick your sword, opening a thin cut on Laertes&rsquo;s cheek.
    ~Hit(hits)
    ~hits += 1
    -> fight_loop
*[Thrust]
    You dip your point under Laretes&rsquo;s guard and extend, pinking his left shoulder.
    ~Hit(hits)
    ~hits += 1
    -> fight_loop
*[Parry]
    # CLEAR
    Laretes slashes at your neck, but you parry with a high one and bind up into a corps-a-corps, swords crossed above your heads.
    This would be a perfect moment for dialog, if you had anything to say.
    Laertes launches a vicious kick at your groin. It connects. You drop your rapier and fall to your knees.
    ++ [Retaliate]
        You seize the target of opportunity, literally, grabbing Laertes&rsquo;s codpiece.
        Your eyes widen with the shock of recognition.
        &ldquo;Ophelia?&rdquo;
        Laertes brandishes his rapier.
        &ldquo;I have rememberances of yours that I have longed to re-deliver. I pray you now&mdash;receive them.&rdquo; # CLASS: ophelia
        He thrusts.
* [Kill Claudius]
    You&rsquo;re going to have to deal with Laertes first.
    -> fight_loop
-
&ldquo;Hamlett, thou art slain. In thee there is not half an hour of life&mdash;&rdquo; # CLASS: ophelia

&ldquo;The fatal instrument is in thy guts, inscribéd and envenomed with your blandishments and toxic masculinity.&rdquo; # CLASS: ophelia
Indeed, as Laertes slowly pulls the rapier from your bowels, you see your own words to Ophelia etched on the blade, and you feel a pang of regret ... that is over-matched by the agony of the finely-honed steel slicing your viscera.
+ &ldquo;I did love you once.&rdquo;
- &ldquo;Indeed, you made me believe so.&rdquo; # CLASS: ophelia
You press your hand over the wound, but it barely stems the tide of blood. There&rsquo;s nothing left to do but wait to die.
+ [Wait to die]
+ [Kill Claudius]
-
# CLEAR
A shot rings out. Laertes blinks in surprise, and a carnation of blood blooms on his chest. He slumps to the floor.
From somewhere under his voluminous robes, Claudius has pulled a revolver.
&ldquo;He was in my way. Now it&rsquo;s your turn.&rdquo; # CLASS: claudius
The Fat Man trains his gun on you.
&ldquo;No!&rdquo; # CLASS: gertrude
Gertrude dives between you and Cladius, taking two in the chest for her trouble. She expires at your feet.
Claudius howls and begins firing wildly, spraying the room with bullets, shattering the bottle on your desk and the face of the grandfather clock, but somehow, miraculously, missing you.
After a dozen shots or more, he pauses to reload his six-shooter.
+ [Kill Claudius]
- 
&ldquo;Blood and gore! Blood and gore!&rdquo; # CLASS: raven
Claudius blasts the raven at close range, who squawks&mdash;<strong>&ldquo;Nevermore!&rdquo;</strong>&mdash;and dies.
The ghost of your father floats through your office door.
For the first time in memory, your uncle looks nervous. He fires a baker&rsquo;s dozen of shots at the ghost, but the bullets pass through harmlessly.
The ghost smiles and reaches out with a translucent hand, through your uncle&rsquo;s chest, to caress his stony heart&mdash;and squeeze. And squeeze and squeeze and squeeze.
The building shudders as the Fat Man falls to the floor, dead.
+ &ldquo;What about me?&rdquo;
- The ghost ignores you, drifting instead in the direction of his murdered wife, Gertrude.
+ &ldquo;What about me?&rdquo;
- The ghost, still ignoring you, sails past the body of Gertrude as well, and instead gently scoops up the body of the raven, his beloved pet, the black bird that kept his counsel under the sycamore in the back yard all those years.
He brushes the blood-matted feathers into place, showing more tenderness than you&rsquo;ve ever seen him display with your mother, or, indeed, you.
The ghost sails through the closed door once more, leaving you, again, alone.
+ [Open door]
- The door remains locked.
+ &ldquo;What about me?&rdquo;
- But there is no one, living or dead, to hear you.
 The End # END
 -> END

===Ophelia (-> back) ===
# CLEAR
The intercom squawks. Your secretary is an early bird&mdash;<strong>&ldquo;Eleanor!&rdquo;</strong>&mdash;which makes you the worm. Hey, you&rsquo;d crawl through the dirt for her anytime. You&rsquo;d had a thing going, which is why you hired her, but since then she&rsquo;s given you the big brush off. Well, there&rsquo;s more than one suicide blonde in Denmark.
+ &ldquo;What is it, dollface?&rdquo;
- &ldquo;You have a client.&rdquo; # CLASS: secretary
+ &ldquo;Send him in.&rdquo;
- &ldquo;He&rsquo;s a she.&rdquo; # CLASS: secretary
Well. Things are looking up already. You already have one client, but a private dick is nothing without a femme fatale.
The door swings open, and <em>she</em> walks in&mdash;ten pounds of sex in a five-pound bag. She strolls across the floor like she&rsquo;s massaging it with her feet and wants to give it a happy ending.
She&rsquo;s a knockout, with breasts like two hills of beans. She looks like heaven, but she smells like trouble.
&ldquo;Hi there.&rdquo; # CLASS: ophelia
+ &ldquo;The name&rsquo;s Hamlett. Dashiell Hamlett.&rdquo;
&ldquo;Pleased to meet you. I&rsquo;m Ophelia. Ophelia Cairo.&rdquo;
She pronounces it &ldquo;Ah-feel-ya&rdquo; to rhyme with &ldquo;meetcha.&rdquo;
- She wants to hire you for some undercover work.
+ &ldquo;Ninety percent of a private eye&rsquo;s job is undercover work.&rdquo;
- She wants you to find a black statuette of a bird.
&ldquo;Evermore!&rdquo; # CLASS: raven
The money is good, but you smell something fishy. It could be coming from the wastebasket. She&rsquo;s <em>too</em> good looking. She&rsquo;s a fox. A fox in sheep&rsquo;s clothing.
+ &ldquo;Is that a sheepskin you&rsquo;re wearing?&rdquo;
- She giggles.
&ldquo;No, but I&rsquo;ve got a sheepskin in my wallet. This is a fox stole.&rdquo; # CLASS: ophelia
Which makes her a wolf in fox&rsquo;s clothing. No wonder it fits so tight.
Ordinarily, you don&rsquo;t like to mix business with pleasure, but this girl is anything but ordinary.
+ &ldquo;Lady, shall I lie in your lap?&rdquo;
- &ldquo;I&rsquo;m here on business, Mr. Dashing.&rdquo;
+ &ldquo;Dashiell is my first name.&rdquo;
- &ldquo;Sorry. Mr. ... Hamlett, was it? That&rsquo;s like a piglet, but larger?&rdquo;
No question, this dame is getting to you. You don&rsquo;t even know her, but you want her more than any woman you&rsquo;ve ever met. She wants you to want her, and you want her like she wants you to. And she&rsquo;s counting on it, but you don&rsquo;t care.
+&ldquo;Hold it right there, sweetheart. Hand me the gun.&rdquo;
-In that tight dress, it&rsquo;s no trouble to spot she&rsquo;s packing something.
&ldquo;What gun?&rdquo; # CLASS: ophelia
+ &ldquo;Sorry, sister, but either you give me the gun or you stand for a search. There&rsquo;s no third way.&rdquo;
-&ldquo;Help yourself.&rdquo; # CLASS: ophelia
+ [Search Ophelia]
- You search, but there&rsquo;s nothing under her dress but what God gave her. On a one to ten scale, she&rsquo;s an eleven&mdash;a ten with something extra. But she doesn&rsquo;t have a gun.
She puts a finger to your lips.
&ldquo;This can be our little secret. You don&rsquo;t have to tell The Fat Man.&rdquo; # CLASS: ophelia
The door swings open. Ophelia strolls over to it and leans on the door frame.
&ldquo;"Call me sometime. You know how to call, don&rsquo;t you?&rdquo; # CLASS: ophelia
+ [Agree]
    "Oh, I know how to call." You waggle your index finger at her.
+ [Disagree]
    "No, but I know how to whistle."
- She smiles and exits. The door slams shut behind her.
+ [Follow Ophelia]
    It&rsquo;s locked. From the outside. Strange.
-
+ [Page secretary]
    Your intercom appears to be a one-way device. Much like your office door.
- You&rsquo;re alone.
It doesn&rsquo;t take much to see that the problems of one private detective don&rsquo;t add up to a hill of beans in this crazy world. Or two hills of beans. Two gorgeous, heaping mounds of vanilla beans.
You have two clients.
-> back
